package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AppManaged
import scala.jdk.CollectionConverters._
final case class ProcessingOutput(
    outputName: String,
    s3Output: Optional[zio.aws.sagemaker.model.ProcessingS3Output] =
      Optional.Absent,
    featureStoreOutput: Optional[
      zio.aws.sagemaker.model.ProcessingFeatureStoreOutput
    ] = Optional.Absent,
    appManaged: Optional[AppManaged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingOutput = {
    import ProcessingOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingOutput
      .builder()
      .outputName(outputName: java.lang.String)
      .optionallyWith(s3Output.map(value => value.buildAwsValue()))(_.s3Output)
      .optionallyWith(featureStoreOutput.map(value => value.buildAwsValue()))(
        _.featureStoreOutput
      )
      .optionallyWith(
        appManaged.map(value => AppManaged.unwrap(value): java.lang.Boolean)
      )(_.appManaged)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingOutput.ReadOnly =
    zio.aws.sagemaker.model.ProcessingOutput.wrap(buildAwsValue())
}
object ProcessingOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingOutput =
      zio.aws.sagemaker.model.ProcessingOutput(
        outputName,
        s3Output.map(value => value.asEditable),
        featureStoreOutput.map(value => value.asEditable),
        appManaged.map(value => value)
      )
    def outputName: String
    def s3Output: Optional[zio.aws.sagemaker.model.ProcessingS3Output.ReadOnly]
    def featureStoreOutput: Optional[
      zio.aws.sagemaker.model.ProcessingFeatureStoreOutput.ReadOnly
    ]
    def appManaged: Optional[AppManaged]
    def getOutputName: ZIO[Any, Nothing, String] = ZIO.succeed(outputName)
    def getS3Output: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingS3Output.ReadOnly
    ] = AwsError.unwrapOptionField("s3Output", s3Output)
    def getFeatureStoreOutput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingFeatureStoreOutput.ReadOnly
    ] = AwsError.unwrapOptionField("featureStoreOutput", featureStoreOutput)
    def getAppManaged: ZIO[Any, AwsError, AppManaged] =
      AwsError.unwrapOptionField("appManaged", appManaged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingOutput
  ) extends zio.aws.sagemaker.model.ProcessingOutput.ReadOnly {
    override val outputName: String = impl.outputName(): String
    override val s3Output
        : Optional[zio.aws.sagemaker.model.ProcessingS3Output.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Output())
        .map(value => zio.aws.sagemaker.model.ProcessingS3Output.wrap(value))
    override val featureStoreOutput: Optional[
      zio.aws.sagemaker.model.ProcessingFeatureStoreOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.featureStoreOutput())
      .map(value =>
        zio.aws.sagemaker.model.ProcessingFeatureStoreOutput.wrap(value)
      )
    override val appManaged: Optional[AppManaged] = zio.aws.core.internal
      .optionalFromNullable(impl.appManaged())
      .map(value => zio.aws.sagemaker.model.primitives.AppManaged(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingOutput
  ): zio.aws.sagemaker.model.ProcessingOutput.ReadOnly = new Wrapper(impl)
}
