package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{String256, Timestamp, String40}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class QueryFilters(
    types: Optional[Iterable[String40]] = Optional.Absent,
    lineageTypes: Optional[Iterable[zio.aws.sagemaker.model.LineageType]] =
      Optional.Absent,
    createdBefore: Optional[Timestamp] = Optional.Absent,
    createdAfter: Optional[Timestamp] = Optional.Absent,
    modifiedBefore: Optional[Timestamp] = Optional.Absent,
    modifiedAfter: Optional[Timestamp] = Optional.Absent,
    properties: Optional[Map[String256, String256]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.QueryFilters = {
    import QueryFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.QueryFilters
      .builder()
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            String40.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(
        lineageTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.lineageTypesWithStrings)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        modifiedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedBefore)
      .optionallyWith(
        modifiedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedAfter)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (String256.unwrap(key): java.lang.String) -> (String256
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.QueryFilters.ReadOnly =
    zio.aws.sagemaker.model.QueryFilters.wrap(buildAwsValue())
}
object QueryFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.QueryFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.QueryFilters =
      zio.aws.sagemaker.model.QueryFilters(
        types.map(value => value),
        lineageTypes.map(value => value),
        createdBefore.map(value => value),
        createdAfter.map(value => value),
        modifiedBefore.map(value => value),
        modifiedAfter.map(value => value),
        properties.map(value => value)
      )
    def types: Optional[List[String40]]
    def lineageTypes: Optional[List[zio.aws.sagemaker.model.LineageType]]
    def createdBefore: Optional[Timestamp]
    def createdAfter: Optional[Timestamp]
    def modifiedBefore: Optional[Timestamp]
    def modifiedAfter: Optional[Timestamp]
    def properties: Optional[Map[String256, String256]]
    def getTypes: ZIO[Any, AwsError, List[String40]] =
      AwsError.unwrapOptionField("types", types)
    def getLineageTypes
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.LineageType]] =
      AwsError.unwrapOptionField("lineageTypes", lineageTypes)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getModifiedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedBefore", modifiedBefore)
    def getModifiedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedAfter", modifiedAfter)
    def getProperties: ZIO[Any, AwsError, Map[String256, String256]] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.QueryFilters
  ) extends zio.aws.sagemaker.model.QueryFilters.ReadOnly {
    override val types: Optional[List[String40]] = zio.aws.core.internal
      .optionalFromNullable(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.String40(item)
        }.toList
      )
    override val lineageTypes
        : Optional[List[zio.aws.sagemaker.model.LineageType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.LineageType.wrap(item)
          }.toList
        )
    override val createdBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val properties: Optional[Map[String256, String256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.String256(
                key
              ) -> zio.aws.sagemaker.model.primitives.String256(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.QueryFilters
  ): zio.aws.sagemaker.model.QueryFilters.ReadOnly = new Wrapper(impl)
}
