package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.RoleArn
import scala.jdk.CollectionConverters._
final case class RStudioServerProDomainSettingsForUpdate(
    domainExecutionRoleArn: RoleArn,
    defaultResourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate = {
    import RStudioServerProDomainSettingsForUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate
      .builder()
      .domainExecutionRoleArn(
        RoleArn.unwrap(domainExecutionRoleArn): java.lang.String
      )
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly =
    zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate
      .wrap(buildAwsValue())
}
object RStudioServerProDomainSettingsForUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate =
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate(
        domainExecutionRoleArn,
        defaultResourceSpec.map(value => value.asEditable)
      )
    def domainExecutionRoleArn: RoleArn
    def defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def getDomainExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(domainExecutionRoleArn)
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate
  ) extends zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly {
    override val domainExecutionRoleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.domainExecutionRoleArn())
    override val defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultResourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate
  ): zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly =
    new Wrapper(impl)
}
