package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait RecommendationJobType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobType
}
object RecommendationJobType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RecommendationJobType
  ): zio.aws.sagemaker.model.RecommendationJobType = value match {
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobType.DEFAULT =>
      val r = Default
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationJobType.ADVANCED =>
      val r = Advanced
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RecommendationJobType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobType =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobType.UNKNOWN_TO_SDK_VERSION
  }
  case object Default extends zio.aws.sagemaker.model.RecommendationJobType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobType =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobType.DEFAULT
  }
  case object Advanced extends zio.aws.sagemaker.model.RecommendationJobType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationJobType =
      software.amazon.awssdk.services.sagemaker.model.RecommendationJobType.ADVANCED
  }
}
