package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.String256
import scala.jdk.CollectionConverters._
final case class RegisterModelStepMetadata(
    arn: Optional[String256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RegisterModelStepMetadata = {
    import RegisterModelStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RegisterModelStepMetadata
      .builder()
      .optionallyWith(
        arn.map(value => String256.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RegisterModelStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.RegisterModelStepMetadata.wrap(buildAwsValue())
}
object RegisterModelStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RegisterModelStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RegisterModelStepMetadata =
      zio.aws.sagemaker.model.RegisterModelStepMetadata(arn.map(value => value))
    def arn: Optional[String256]
    def getArn: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RegisterModelStepMetadata
  ) extends zio.aws.sagemaker.model.RegisterModelStepMetadata.ReadOnly {
    override val arn: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RegisterModelStepMetadata
  ): zio.aws.sagemaker.model.RegisterModelStepMetadata.ReadOnly = new Wrapper(
    impl
  )
}
