package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RenderUiTemplateResponse(
    renderedContent: String,
    errors: Iterable[zio.aws.sagemaker.model.RenderingError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse = {
    import RenderUiTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse
      .builder()
      .renderedContent(renderedContent: java.lang.String)
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RenderUiTemplateResponse.ReadOnly =
    zio.aws.sagemaker.model.RenderUiTemplateResponse.wrap(buildAwsValue())
}
object RenderUiTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RenderUiTemplateResponse =
      zio.aws.sagemaker.model.RenderUiTemplateResponse(
        renderedContent,
        errors.map { item =>
          item.asEditable
        }
      )
    def renderedContent: String
    def errors: List[zio.aws.sagemaker.model.RenderingError.ReadOnly]
    def getRenderedContent: ZIO[Any, Nothing, String] =
      ZIO.succeed(renderedContent)
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.RenderingError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse
  ) extends zio.aws.sagemaker.model.RenderUiTemplateResponse.ReadOnly {
    override val renderedContent: String = impl.renderedContent(): String
    override val errors: List[zio.aws.sagemaker.model.RenderingError.ReadOnly] =
      impl
        .errors()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.RenderingError.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse
  ): zio.aws.sagemaker.model.RenderUiTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
