package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  MaxParallelTrainingJobs,
  MaxNumberOfTrainingJobs
}
import scala.jdk.CollectionConverters._
final case class ResourceLimits(
    maxNumberOfTrainingJobs: MaxNumberOfTrainingJobs,
    maxParallelTrainingJobs: MaxParallelTrainingJobs
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResourceLimits = {
    import ResourceLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResourceLimits
      .builder()
      .maxNumberOfTrainingJobs(
        MaxNumberOfTrainingJobs.unwrap(maxNumberOfTrainingJobs): Integer
      )
      .maxParallelTrainingJobs(
        MaxParallelTrainingJobs.unwrap(maxParallelTrainingJobs): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResourceLimits.ReadOnly =
    zio.aws.sagemaker.model.ResourceLimits.wrap(buildAwsValue())
}
object ResourceLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResourceLimits =
      zio.aws.sagemaker.model
        .ResourceLimits(maxNumberOfTrainingJobs, maxParallelTrainingJobs)
    def maxNumberOfTrainingJobs: MaxNumberOfTrainingJobs
    def maxParallelTrainingJobs: MaxParallelTrainingJobs
    def getMaxNumberOfTrainingJobs: ZIO[Any, Nothing, MaxNumberOfTrainingJobs] =
      ZIO.succeed(maxNumberOfTrainingJobs)
    def getMaxParallelTrainingJobs: ZIO[Any, Nothing, MaxParallelTrainingJobs] =
      ZIO.succeed(maxParallelTrainingJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ) extends zio.aws.sagemaker.model.ResourceLimits.ReadOnly {
    override val maxNumberOfTrainingJobs: MaxNumberOfTrainingJobs =
      zio.aws.sagemaker.model.primitives
        .MaxNumberOfTrainingJobs(impl.maxNumberOfTrainingJobs())
    override val maxParallelTrainingJobs: MaxParallelTrainingJobs =
      zio.aws.sagemaker.model.primitives
        .MaxParallelTrainingJobs(impl.maxParallelTrainingJobs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ): zio.aws.sagemaker.model.ResourceLimits.ReadOnly = new Wrapper(impl)
}
