package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait S3DataDistribution {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.S3DataDistribution
}
object S3DataDistribution {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.S3DataDistribution
  ): zio.aws.sagemaker.model.S3DataDistribution = value match {
    case software.amazon.awssdk.services.sagemaker.model.S3DataDistribution.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.S3DataDistribution.FULLY_REPLICATED =>
      val r = FullyReplicated
      r
    case software.amazon.awssdk.services.sagemaker.model.S3DataDistribution.SHARDED_BY_S3_KEY =>
      val r = ShardedByS3Key
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.S3DataDistribution {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3DataDistribution =
      software.amazon.awssdk.services.sagemaker.model.S3DataDistribution.UNKNOWN_TO_SDK_VERSION
  }
  case object FullyReplicated
      extends zio.aws.sagemaker.model.S3DataDistribution {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3DataDistribution =
      software.amazon.awssdk.services.sagemaker.model.S3DataDistribution.FULLY_REPLICATED
  }
  case object ShardedByS3Key
      extends zio.aws.sagemaker.model.S3DataDistribution {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3DataDistribution =
      software.amazon.awssdk.services.sagemaker.model.S3DataDistribution.SHARDED_BY_S3_KEY
  }
}
