package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait S3DataType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.S3DataType
}
object S3DataType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.S3DataType
  ): zio.aws.sagemaker.model.S3DataType = value match {
    case software.amazon.awssdk.services.sagemaker.model.S3DataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.S3DataType.MANIFEST_FILE =>
      val r = ManifestFile
      r
    case software.amazon.awssdk.services.sagemaker.model.S3DataType.S3_PREFIX =>
      val r = S3Prefix
      r
    case software.amazon.awssdk.services.sagemaker.model.S3DataType.AUGMENTED_MANIFEST_FILE =>
      val r = AugmentedManifestFile
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.S3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3DataType =
      software.amazon.awssdk.services.sagemaker.model.S3DataType.UNKNOWN_TO_SDK_VERSION
  }
  case object ManifestFile extends zio.aws.sagemaker.model.S3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3DataType =
      software.amazon.awssdk.services.sagemaker.model.S3DataType.MANIFEST_FILE
  }
  case object S3Prefix extends zio.aws.sagemaker.model.S3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3DataType =
      software.amazon.awssdk.services.sagemaker.model.S3DataType.S3_PREFIX
  }
  case object AugmentedManifestFile extends zio.aws.sagemaker.model.S3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.S3DataType =
      software.amazon.awssdk.services.sagemaker.model.S3DataType.AUGMENTED_MANIFEST_FILE
  }
}
