package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ProvisionedProductStatusMessage,
  ServiceCatalogEntityId
}
import scala.jdk.CollectionConverters._
final case class ServiceCatalogProvisionedProductDetails(
    provisionedProductId: Optional[ServiceCatalogEntityId] = Optional.Absent,
    provisionedProductStatusMessage: Optional[ProvisionedProductStatusMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisionedProductDetails = {
    import ServiceCatalogProvisionedProductDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisionedProductDetails
      .builder()
      .optionallyWith(
        provisionedProductId.map(value =>
          ServiceCatalogEntityId.unwrap(value): java.lang.String
        )
      )(_.provisionedProductId)
      .optionallyWith(
        provisionedProductStatusMessage.map(value =>
          ProvisionedProductStatusMessage.unwrap(value): java.lang.String
        )
      )(_.provisionedProductStatusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly =
    zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails
      .wrap(buildAwsValue())
}
object ServiceCatalogProvisionedProductDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisionedProductDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails =
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails(
        provisionedProductId.map(value => value),
        provisionedProductStatusMessage.map(value => value)
      )
    def provisionedProductId: Optional[ServiceCatalogEntityId]
    def provisionedProductStatusMessage
        : Optional[ProvisionedProductStatusMessage]
    def getProvisionedProductId: ZIO[Any, AwsError, ServiceCatalogEntityId] =
      AwsError.unwrapOptionField("provisionedProductId", provisionedProductId)
    def getProvisionedProductStatusMessage
        : ZIO[Any, AwsError, ProvisionedProductStatusMessage] =
      AwsError.unwrapOptionField(
        "provisionedProductStatusMessage",
        provisionedProductStatusMessage
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisionedProductDetails
  ) extends zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly {
    override val provisionedProductId: Optional[ServiceCatalogEntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedProductId())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ServiceCatalogEntityId(value)
        )
    override val provisionedProductStatusMessage
        : Optional[ProvisionedProductStatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProductStatusMessage())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .ProvisionedProductStatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisionedProductDetails
  ): zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly =
    new Wrapper(impl)
}
