package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.AutoMLJobName
import scala.jdk.CollectionConverters._
final case class StopAutoMlJobRequest(autoMLJobName: AutoMLJobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest = {
    import StopAutoMlJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StopAutoMlJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopAutoMlJobRequest.wrap(buildAwsValue())
}
object StopAutoMlJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopAutoMlJobRequest =
      zio.aws.sagemaker.model.StopAutoMlJobRequest(autoMLJobName)
    def autoMLJobName: AutoMLJobName
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest
  ) extends zio.aws.sagemaker.model.StopAutoMlJobRequest.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest
  ): zio.aws.sagemaker.model.StopAutoMlJobRequest.ReadOnly = new Wrapper(impl)
}
