package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait StudioLifecycleConfigAppType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType
}
object StudioLifecycleConfigAppType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType
  ): zio.aws.sagemaker.model.StudioLifecycleConfigAppType = value match {
    case software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType.JUPYTER_SERVER =>
      val r = JupyterServer
      r
    case software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType.KERNEL_GATEWAY =>
      val r = KernelGateway
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.StudioLifecycleConfigAppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType =
      software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType.UNKNOWN_TO_SDK_VERSION
  }
  case object JupyterServer
      extends zio.aws.sagemaker.model.StudioLifecycleConfigAppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType =
      software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType.JUPYTER_SERVER
  }
  case object KernelGateway
      extends zio.aws.sagemaker.model.StudioLifecycleConfigAppType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType =
      software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigAppType.KERNEL_GATEWAY
  }
}
