package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait TargetPlatformArch {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch
}
object TargetPlatformArch {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch
  ): zio.aws.sagemaker.model.TargetPlatformArch = value match {
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.X86_64 =>
      val r = X86_64
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.X86 =>
      val r = X86
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.ARM64 =>
      val r = ARM64
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.ARM_EABI =>
      val r = ARM_EABI
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.ARM_EABIHF =>
      val r = ARM_EABIHF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.UNKNOWN_TO_SDK_VERSION
  }
  case object X86_64 extends zio.aws.sagemaker.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.X86_64
  }
  case object X86 extends zio.aws.sagemaker.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.X86
  }
  case object ARM64 extends zio.aws.sagemaker.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.ARM64
  }
  case object ARM_EABI extends zio.aws.sagemaker.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.ARM_EABI
  }
  case object ARM_EABIHF extends zio.aws.sagemaker.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch.ARM_EABIHF
  }
}
