package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TransformDataSource(
    s3DataSource: zio.aws.sagemaker.model.TransformS3DataSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformDataSource = {
    import TransformDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformDataSource
      .builder()
      .s3DataSource(s3DataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformDataSource.ReadOnly =
    zio.aws.sagemaker.model.TransformDataSource.wrap(buildAwsValue())
}
object TransformDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformDataSource =
      zio.aws.sagemaker.model.TransformDataSource(s3DataSource.asEditable)
    def s3DataSource: zio.aws.sagemaker.model.TransformS3DataSource.ReadOnly
    def getS3DataSource: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TransformS3DataSource.ReadOnly
    ] = ZIO.succeed(s3DataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformDataSource
  ) extends zio.aws.sagemaker.model.TransformDataSource.ReadOnly {
    override val s3DataSource
        : zio.aws.sagemaker.model.TransformS3DataSource.ReadOnly =
      zio.aws.sagemaker.model.TransformS3DataSource.wrap(impl.s3DataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformDataSource
  ): zio.aws.sagemaker.model.TransformDataSource.ReadOnly = new Wrapper(impl)
}
