package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TenthFractionsOfACent,
  Cents,
  Dollars
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class USD(
    dollars: Optional[Dollars] = Optional.Absent,
    cents: Optional[Cents] = Optional.Absent,
    tenthFractionsOfACent: Optional[TenthFractionsOfACent] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.USD = {
    import USD.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.USD
      .builder()
      .optionallyWith(dollars.map(value => Dollars.unwrap(value): Integer))(
        _.dollars
      )
      .optionallyWith(cents.map(value => Cents.unwrap(value): Integer))(_.cents)
      .optionallyWith(
        tenthFractionsOfACent.map(value =>
          TenthFractionsOfACent.unwrap(value): Integer
        )
      )(_.tenthFractionsOfACent)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.USD.ReadOnly =
    zio.aws.sagemaker.model.USD.wrap(buildAwsValue())
}
object USD {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.USD] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.USD = zio.aws.sagemaker.model.USD(
      dollars.map(value => value),
      cents.map(value => value),
      tenthFractionsOfACent.map(value => value)
    )
    def dollars: Optional[Dollars]
    def cents: Optional[Cents]
    def tenthFractionsOfACent: Optional[TenthFractionsOfACent]
    def getDollars: ZIO[Any, AwsError, Dollars] =
      AwsError.unwrapOptionField("dollars", dollars)
    def getCents: ZIO[Any, AwsError, Cents] =
      AwsError.unwrapOptionField("cents", cents)
    def getTenthFractionsOfACent: ZIO[Any, AwsError, TenthFractionsOfACent] =
      AwsError.unwrapOptionField("tenthFractionsOfACent", tenthFractionsOfACent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.USD
  ) extends zio.aws.sagemaker.model.USD.ReadOnly {
    override val dollars: Optional[Dollars] = zio.aws.core.internal
      .optionalFromNullable(impl.dollars())
      .map(value => zio.aws.sagemaker.model.primitives.Dollars(value))
    override val cents: Optional[Cents] = zio.aws.core.internal
      .optionalFromNullable(impl.cents())
      .map(value => zio.aws.sagemaker.model.primitives.Cents(value))
    override val tenthFractionsOfACent: Optional[TenthFractionsOfACent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenthFractionsOfACent())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TenthFractionsOfACent(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.USD
  ): zio.aws.sagemaker.model.USD.ReadOnly = new Wrapper(impl)
}
