package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AppImageConfigName
import scala.jdk.CollectionConverters._
final case class UpdateAppImageConfigRequest(
    appImageConfigName: AppImageConfigName,
    kernelGatewayImageConfig: Optional[
      zio.aws.sagemaker.model.KernelGatewayImageConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest = {
    import UpdateAppImageConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest
      .builder()
      .appImageConfigName(
        AppImageConfigName.unwrap(appImageConfigName): java.lang.String
      )
      .optionallyWith(
        kernelGatewayImageConfig.map(value => value.buildAwsValue())
      )(_.kernelGatewayImageConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateAppImageConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateAppImageConfigRequest.wrap(buildAwsValue())
}
object UpdateAppImageConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateAppImageConfigRequest =
      zio.aws.sagemaker.model.UpdateAppImageConfigRequest(
        appImageConfigName,
        kernelGatewayImageConfig.map(value => value.asEditable)
      )
    def appImageConfigName: AppImageConfigName
    def kernelGatewayImageConfig
        : Optional[zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly]
    def getAppImageConfigName: ZIO[Any, Nothing, AppImageConfigName] =
      ZIO.succeed(appImageConfigName)
    def getKernelGatewayImageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kernelGatewayImageConfig",
      kernelGatewayImageConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest
  ) extends zio.aws.sagemaker.model.UpdateAppImageConfigRequest.ReadOnly {
    override val appImageConfigName: AppImageConfigName =
      zio.aws.sagemaker.model.primitives
        .AppImageConfigName(impl.appImageConfigName())
    override val kernelGatewayImageConfig
        : Optional[zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kernelGatewayImageConfig())
        .map(value =>
          zio.aws.sagemaker.model.KernelGatewayImageConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest
  ): zio.aws.sagemaker.model.UpdateAppImageConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
