package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.DomainId
import scala.jdk.CollectionConverters._
final case class UpdateDomainRequest(
    domainId: DomainId,
    defaultUserSettings: Optional[zio.aws.sagemaker.model.UserSettings] =
      Optional.Absent,
    domainSettingsForUpdate: Optional[
      zio.aws.sagemaker.model.DomainSettingsForUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest = {
    import UpdateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(defaultUserSettings.map(value => value.buildAwsValue()))(
        _.defaultUserSettings
      )
      .optionallyWith(
        domainSettingsForUpdate.map(value => value.buildAwsValue())
      )(_.domainSettingsForUpdate)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateDomainRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateDomainRequest.wrap(buildAwsValue())
}
object UpdateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateDomainRequest =
      zio.aws.sagemaker.model.UpdateDomainRequest(
        domainId,
        defaultUserSettings.map(value => value.asEditable),
        domainSettingsForUpdate.map(value => value.asEditable)
      )
    def domainId: DomainId
    def defaultUserSettings
        : Optional[zio.aws.sagemaker.model.UserSettings.ReadOnly]
    def domainSettingsForUpdate
        : Optional[zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getDefaultUserSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("defaultUserSettings", defaultUserSettings)
    def getDomainSettingsForUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "domainSettingsForUpdate",
      domainSettingsForUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest
  ) extends zio.aws.sagemaker.model.UpdateDomainRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val defaultUserSettings
        : Optional[zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultUserSettings())
        .map(value => zio.aws.sagemaker.model.UserSettings.wrap(value))
    override val domainSettingsForUpdate
        : Optional[zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainSettingsForUpdate())
        .map(value =>
          zio.aws.sagemaker.model.DomainSettingsForUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest
  ): zio.aws.sagemaker.model.UpdateDomainRequest.ReadOnly = new Wrapper(impl)
}
