package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.DomainArn
import scala.jdk.CollectionConverters._
final case class UpdateDomainResponse(
    domainArn: Optional[DomainArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse = {
    import UpdateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse
      .builder()
      .optionallyWith(
        domainArn.map(value => DomainArn.unwrap(value): java.lang.String)
      )(_.domainArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateDomainResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateDomainResponse.wrap(buildAwsValue())
}
object UpdateDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateDomainResponse =
      zio.aws.sagemaker.model
        .UpdateDomainResponse(domainArn.map(value => value))
    def domainArn: Optional[DomainArn]
    def getDomainArn: ZIO[Any, AwsError, DomainArn] =
      AwsError.unwrapOptionField("domainArn", domainArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse
  ) extends zio.aws.sagemaker.model.UpdateDomainResponse.ReadOnly {
    override val domainArn: Optional[DomainArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainArn())
      .map(value => zio.aws.sagemaker.model.primitives.DomainArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse
  ): zio.aws.sagemaker.model.UpdateDomainResponse.ReadOnly = new Wrapper(impl)
}
