package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointArn
import scala.jdk.CollectionConverters._
final case class UpdateEndpointResponse(endpointArn: EndpointArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse = {
    import UpdateEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse
      .builder()
      .endpointArn(EndpointArn.unwrap(endpointArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateEndpointResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateEndpointResponse.wrap(buildAwsValue())
}
object UpdateEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateEndpointResponse =
      zio.aws.sagemaker.model.UpdateEndpointResponse(endpointArn)
    def endpointArn: EndpointArn
    def getEndpointArn: ZIO[Any, Nothing, EndpointArn] =
      ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse
  ) extends zio.aws.sagemaker.model.UpdateEndpointResponse.ReadOnly {
    override val endpointArn: EndpointArn =
      zio.aws.sagemaker.model.primitives.EndpointArn(impl.endpointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse
  ): zio.aws.sagemaker.model.UpdateEndpointResponse.ReadOnly = new Wrapper(impl)
}
