package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ProjectArn
import scala.jdk.CollectionConverters._
final case class UpdateProjectResponse(projectArn: ProjectArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse = {
    import UpdateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateProjectResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateProjectResponse.wrap(buildAwsValue())
}
object UpdateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateProjectResponse =
      zio.aws.sagemaker.model.UpdateProjectResponse(projectArn)
    def projectArn: ProjectArn
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse
  ) extends zio.aws.sagemaker.model.UpdateProjectResponse.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.sagemaker.model.primitives.ProjectArn(impl.projectArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse
  ): zio.aws.sagemaker.model.UpdateProjectResponse.ReadOnly = new Wrapper(impl)
}
