package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TrainingJobArn
import scala.jdk.CollectionConverters._
final case class UpdateTrainingJobResponse(trainingJobArn: TrainingJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse = {
    import UpdateTrainingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse
      .builder()
      .trainingJobArn(TrainingJobArn.unwrap(trainingJobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateTrainingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateTrainingJobResponse.wrap(buildAwsValue())
}
object UpdateTrainingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateTrainingJobResponse =
      zio.aws.sagemaker.model.UpdateTrainingJobResponse(trainingJobArn)
    def trainingJobArn: TrainingJobArn
    def getTrainingJobArn: ZIO[Any, Nothing, TrainingJobArn] =
      ZIO.succeed(trainingJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse
  ) extends zio.aws.sagemaker.model.UpdateTrainingJobResponse.ReadOnly {
    override val trainingJobArn: TrainingJobArn =
      zio.aws.sagemaker.model.primitives.TrainingJobArn(impl.trainingJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse
  ): zio.aws.sagemaker.model.UpdateTrainingJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
