package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  String64,
  ExperimentEntityName,
  ActionArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ActionSummary(
    actionArn: Optional[ActionArn] = Optional.Absent,
    actionName: Optional[ExperimentEntityName] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.ActionSource] = Optional.Absent,
    actionType: Optional[String64] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.ActionStatus] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ActionSummary = {
    import ActionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ActionSummary
      .builder()
      .optionallyWith(
        actionArn.map(value => ActionArn.unwrap(value): java.lang.String)
      )(_.actionArn)
      .optionallyWith(
        actionName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        actionType.map(value => String64.unwrap(value): java.lang.String)
      )(_.actionType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ActionSummary.ReadOnly =
    zio.aws.sagemaker.model.ActionSummary.wrap(buildAwsValue())
}
object ActionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ActionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ActionSummary =
      zio.aws.sagemaker.model.ActionSummary(
        actionArn.map(value => value),
        actionName.map(value => value),
        source.map(value => value.asEditable),
        actionType.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def actionArn: Optional[ActionArn]
    def actionName: Optional[ExperimentEntityName]
    def source: Optional[zio.aws.sagemaker.model.ActionSource.ReadOnly]
    def actionType: Optional[String64]
    def status: Optional[zio.aws.sagemaker.model.ActionStatus]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getActionArn: ZIO[Any, AwsError, ActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
    def getActionName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ActionSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getActionType: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ActionSummary
  ) extends zio.aws.sagemaker.model.ActionSummary.ReadOnly {
    override val actionArn: Optional[ActionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.actionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ActionArn(value))
    override val actionName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val source
        : Optional[zio.aws.sagemaker.model.ActionSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.ActionSource.wrap(value))
    override val actionType: Optional[String64] = zio.aws.core.internal
      .optionalFromNullable(impl.actionType())
      .map(value => zio.aws.sagemaker.model.primitives.String64(value))
    override val status: Optional[zio.aws.sagemaker.model.ActionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.ActionStatus.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ActionSummary
  ): zio.aws.sagemaker.model.ActionSummary.ReadOnly = new Wrapper(impl)
}
