package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AlgorithmStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus
}
object AlgorithmStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus
  ): zio.aws.sagemaker.model.AlgorithmStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.sagemaker.model.AlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.PENDING
  }
  case object InProgress extends zio.aws.sagemaker.model.AlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.sagemaker.model.AlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.AlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.FAILED
  }
  case object Deleting extends zio.aws.sagemaker.model.AlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus.DELETING
  }
}
