package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  EntityDescription,
  AlgorithmArn,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AlgorithmSummary(
    algorithmName: EntityName,
    algorithmArn: AlgorithmArn,
    algorithmDescription: Optional[EntityDescription] = Optional.Absent,
    creationTime: CreationTime,
    algorithmStatus: zio.aws.sagemaker.model.AlgorithmStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary = {
    import AlgorithmSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary
      .builder()
      .algorithmName(EntityName.unwrap(algorithmName): java.lang.String)
      .algorithmArn(AlgorithmArn.unwrap(algorithmArn): java.lang.String)
      .optionallyWith(
        algorithmDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.algorithmDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .algorithmStatus(algorithmStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly =
    zio.aws.sagemaker.model.AlgorithmSummary.wrap(buildAwsValue())
}
object AlgorithmSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AlgorithmSummary =
      zio.aws.sagemaker.model.AlgorithmSummary(
        algorithmName,
        algorithmArn,
        algorithmDescription.map(value => value),
        creationTime,
        algorithmStatus
      )
    def algorithmName: EntityName
    def algorithmArn: AlgorithmArn
    def algorithmDescription: Optional[EntityDescription]
    def creationTime: CreationTime
    def algorithmStatus: zio.aws.sagemaker.model.AlgorithmStatus
    def getAlgorithmName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(algorithmName)
    def getAlgorithmArn: ZIO[Any, Nothing, AlgorithmArn] =
      ZIO.succeed(algorithmArn)
    def getAlgorithmDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("algorithmDescription", algorithmDescription)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getAlgorithmStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AlgorithmStatus] =
      ZIO.succeed(algorithmStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary
  ) extends zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly {
    override val algorithmName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.algorithmName())
    override val algorithmArn: AlgorithmArn =
      zio.aws.sagemaker.model.primitives.AlgorithmArn(impl.algorithmArn())
    override val algorithmDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithmDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val algorithmStatus: zio.aws.sagemaker.model.AlgorithmStatus =
      zio.aws.sagemaker.model.AlgorithmStatus.wrap(impl.algorithmStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary
  ): zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly = new Wrapper(impl)
}
