package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.String256
import scala.jdk.CollectionConverters.*
final case class ArtifactSourceType(
    sourceIdType: zio.aws.sagemaker.model.ArtifactSourceIdType,
    value: String256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType = {
    import ArtifactSourceType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType
      .builder()
      .sourceIdType(sourceIdType.unwrap)
      .value(String256.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ArtifactSourceType.ReadOnly =
    zio.aws.sagemaker.model.ArtifactSourceType.wrap(buildAwsValue())
}
object ArtifactSourceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ArtifactSourceType =
      zio.aws.sagemaker.model.ArtifactSourceType(sourceIdType, value)
    def sourceIdType: zio.aws.sagemaker.model.ArtifactSourceIdType
    def value: String256
    def getSourceIdType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ArtifactSourceIdType] =
      ZIO.succeed(sourceIdType)
    def getValue: ZIO[Any, Nothing, String256] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType
  ) extends zio.aws.sagemaker.model.ArtifactSourceType.ReadOnly {
    override val sourceIdType: zio.aws.sagemaker.model.ArtifactSourceIdType =
      zio.aws.sagemaker.model.ArtifactSourceIdType.wrap(impl.sourceIdType())
    override val value: String256 =
      zio.aws.sagemaker.model.primitives.String256(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType
  ): zio.aws.sagemaker.model.ArtifactSourceType.ReadOnly = new Wrapper(impl)
}
