package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{TrialArn, TrialComponentArn}
import scala.jdk.CollectionConverters.*
final case class AssociateTrialComponentResponse(
    trialComponentArn: Optional[TrialComponentArn] = Optional.Absent,
    trialArn: Optional[TrialArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse = {
    import AssociateTrialComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse
      .builder()
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AssociateTrialComponentResponse.ReadOnly =
    zio.aws.sagemaker.model.AssociateTrialComponentResponse
      .wrap(buildAwsValue())
}
object AssociateTrialComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AssociateTrialComponentResponse =
      zio.aws.sagemaker.model.AssociateTrialComponentResponse(
        trialComponentArn.map(value => value),
        trialArn.map(value => value)
      )
    def trialComponentArn: Optional[TrialComponentArn]
    def trialArn: Optional[TrialArn]
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse
  ) extends zio.aws.sagemaker.model.AssociateTrialComponentResponse.ReadOnly {
    override val trialComponentArn: Optional[TrialComponentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentArn(value)
        )
    override val trialArn: Optional[TrialArn] = zio.aws.core.internal
      .optionalFromNullable(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse
  ): zio.aws.sagemaker.model.AssociateTrialComponentResponse.ReadOnly =
    new Wrapper(impl)
}
