package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  EnvironmentValue,
  EnvironmentKey,
  Url,
  ContainerImage
}
import scala.jdk.CollectionConverters.*
final case class AutoMLContainerDefinition(
    image: ContainerImage,
    modelDataUrl: Url,
    environment: Optional[Map[EnvironmentKey, EnvironmentValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition = {
    import AutoMLContainerDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition
      .builder()
      .image(ContainerImage.unwrap(image): java.lang.String)
      .modelDataUrl(Url.unwrap(modelDataUrl): java.lang.String)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentKey
                .unwrap(key): java.lang.String) -> (EnvironmentValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLContainerDefinition.ReadOnly =
    zio.aws.sagemaker.model.AutoMLContainerDefinition.wrap(buildAwsValue())
}
object AutoMLContainerDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLContainerDefinition =
      zio.aws.sagemaker.model.AutoMLContainerDefinition(
        image,
        modelDataUrl,
        environment.map(value => value)
      )
    def image: ContainerImage
    def modelDataUrl: Url
    def environment: Optional[Map[EnvironmentKey, EnvironmentValue]]
    def getImage: ZIO[Any, Nothing, ContainerImage] = ZIO.succeed(image)
    def getModelDataUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(modelDataUrl)
    def getEnvironment
        : ZIO[Any, AwsError, Map[EnvironmentKey, EnvironmentValue]] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition
  ) extends zio.aws.sagemaker.model.AutoMLContainerDefinition.ReadOnly {
    override val image: ContainerImage =
      zio.aws.sagemaker.model.primitives.ContainerImage(impl.image())
    override val modelDataUrl: Url =
      zio.aws.sagemaker.model.primitives.Url(impl.modelDataUrl())
    override val environment: Optional[Map[EnvironmentKey, EnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.EnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.EnvironmentValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition
  ): zio.aws.sagemaker.model.AutoMLContainerDefinition.ReadOnly = new Wrapper(
    impl
  )
}
