package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  DataExplorationNotebookLocation,
  CandidateDefinitionNotebookLocation
}
import scala.jdk.CollectionConverters.*
final case class AutoMLJobArtifacts(
    candidateDefinitionNotebookLocation: Optional[
      CandidateDefinitionNotebookLocation
    ] = Optional.Absent,
    dataExplorationNotebookLocation: Optional[DataExplorationNotebookLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobArtifacts = {
    import AutoMLJobArtifacts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobArtifacts
      .builder()
      .optionallyWith(
        candidateDefinitionNotebookLocation.map(value =>
          CandidateDefinitionNotebookLocation.unwrap(value): java.lang.String
        )
      )(_.candidateDefinitionNotebookLocation)
      .optionallyWith(
        dataExplorationNotebookLocation.map(value =>
          DataExplorationNotebookLocation.unwrap(value): java.lang.String
        )
      )(_.dataExplorationNotebookLocation)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobArtifacts.wrap(buildAwsValue())
}
object AutoMLJobArtifacts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobArtifacts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobArtifacts =
      zio.aws.sagemaker.model.AutoMLJobArtifacts(
        candidateDefinitionNotebookLocation.map(value => value),
        dataExplorationNotebookLocation.map(value => value)
      )
    def candidateDefinitionNotebookLocation
        : Optional[CandidateDefinitionNotebookLocation]
    def dataExplorationNotebookLocation
        : Optional[DataExplorationNotebookLocation]
    def getCandidateDefinitionNotebookLocation
        : ZIO[Any, AwsError, CandidateDefinitionNotebookLocation] =
      AwsError.unwrapOptionField(
        "candidateDefinitionNotebookLocation",
        candidateDefinitionNotebookLocation
      )
    def getDataExplorationNotebookLocation
        : ZIO[Any, AwsError, DataExplorationNotebookLocation] =
      AwsError.unwrapOptionField(
        "dataExplorationNotebookLocation",
        dataExplorationNotebookLocation
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobArtifacts
  ) extends zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly {
    override val candidateDefinitionNotebookLocation
        : Optional[CandidateDefinitionNotebookLocation] = zio.aws.core.internal
      .optionalFromNullable(impl.candidateDefinitionNotebookLocation())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .CandidateDefinitionNotebookLocation(value)
      )
    override val dataExplorationNotebookLocation
        : Optional[DataExplorationNotebookLocation] = zio.aws.core.internal
      .optionalFromNullable(impl.dataExplorationNotebookLocation())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .DataExplorationNotebookLocation(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobArtifacts
  ): zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly = new Wrapper(impl)
}
