package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AutoMLSortOrder {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder
}
object AutoMLSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder
  ): zio.aws.sagemaker.model.AutoMLSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder =
      software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending extends zio.aws.sagemaker.model.AutoMLSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder =
      software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder.ASCENDING
  }
  case object Descending extends zio.aws.sagemaker.model.AutoMLSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder =
      software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder.DESCENDING
  }
}
