package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait BooleanOperator {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.BooleanOperator
}
object BooleanOperator {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.BooleanOperator
  ): zio.aws.sagemaker.model.BooleanOperator = value match {
    case software.amazon.awssdk.services.sagemaker.model.BooleanOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.BooleanOperator.AND =>
      val r = And
      r
    case software.amazon.awssdk.services.sagemaker.model.BooleanOperator.OR =>
      val r = Or
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.BooleanOperator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.BooleanOperator =
      software.amazon.awssdk.services.sagemaker.model.BooleanOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object And extends zio.aws.sagemaker.model.BooleanOperator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.BooleanOperator =
      software.amazon.awssdk.services.sagemaker.model.BooleanOperator.AND
  }
  case object Or extends zio.aws.sagemaker.model.BooleanOperator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.BooleanOperator =
      software.amazon.awssdk.services.sagemaker.model.BooleanOperator.OR
  }
}
