package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait CandidateSortBy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.CandidateSortBy
}
object CandidateSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CandidateSortBy
  ): zio.aws.sagemaker.model.CandidateSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.CandidateSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateSortBy.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateSortBy.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.sagemaker.model.CandidateSortBy.FINAL_OBJECTIVE_METRIC_VALUE =>
      val r = FinalObjectiveMetricValue
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CandidateSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateSortBy =
      software.amazon.awssdk.services.sagemaker.model.CandidateSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CreationTime extends zio.aws.sagemaker.model.CandidateSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateSortBy =
      software.amazon.awssdk.services.sagemaker.model.CandidateSortBy.CREATION_TIME
  }
  case object Status extends zio.aws.sagemaker.model.CandidateSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateSortBy =
      software.amazon.awssdk.services.sagemaker.model.CandidateSortBy.STATUS
  }
  case object FinalObjectiveMetricValue
      extends zio.aws.sagemaker.model.CandidateSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CandidateSortBy =
      software.amazon.awssdk.services.sagemaker.model.CandidateSortBy.FINAL_OBJECTIVE_METRIC_VALUE
  }
}
