package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ClarifyTextGranularity {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity
}
object ClarifyTextGranularity {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity
  ): zio.aws.sagemaker.model.ClarifyTextGranularity = value match {
    case software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity.TOKEN =>
      val r = token
      r
    case software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity.SENTENCE =>
      val r = sentence
      r
    case software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity.PARAGRAPH =>
      val r = paragraph
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ClarifyTextGranularity {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity =
      software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity.UNKNOWN_TO_SDK_VERSION
  }
  case object token extends zio.aws.sagemaker.model.ClarifyTextGranularity {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity =
      software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity.TOKEN
  }
  case object sentence extends zio.aws.sagemaker.model.ClarifyTextGranularity {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity =
      software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity.SENTENCE
  }
  case object paragraph extends zio.aws.sagemaker.model.ClarifyTextGranularity {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity =
      software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity.PARAGRAPH
  }
}
