package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ConfigValue,
  ConfigKey,
  CollectionName
}
import scala.jdk.CollectionConverters.*
final case class CollectionConfiguration(
    collectionName: Optional[CollectionName] = Optional.Absent,
    collectionParameters: Optional[Map[ConfigKey, ConfigValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CollectionConfiguration = {
    import CollectionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CollectionConfiguration
      .builder()
      .optionallyWith(
        collectionName.map(value =>
          CollectionName.unwrap(value): java.lang.String
        )
      )(_.collectionName)
      .optionallyWith(
        collectionParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ConfigKey.unwrap(key): java.lang.String) -> (ConfigValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.collectionParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CollectionConfiguration.ReadOnly =
    zio.aws.sagemaker.model.CollectionConfiguration.wrap(buildAwsValue())
}
object CollectionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CollectionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CollectionConfiguration =
      zio.aws.sagemaker.model.CollectionConfiguration(
        collectionName.map(value => value),
        collectionParameters.map(value => value)
      )
    def collectionName: Optional[CollectionName]
    def collectionParameters: Optional[Map[ConfigKey, ConfigValue]]
    def getCollectionName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("collectionName", collectionName)
    def getCollectionParameters
        : ZIO[Any, AwsError, Map[ConfigKey, ConfigValue]] =
      AwsError.unwrapOptionField("collectionParameters", collectionParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CollectionConfiguration
  ) extends zio.aws.sagemaker.model.CollectionConfiguration.ReadOnly {
    override val collectionName: Optional[CollectionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionName())
        .map(value => zio.aws.sagemaker.model.primitives.CollectionName(value))
    override val collectionParameters: Optional[Map[ConfigKey, ConfigValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ConfigKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.ConfigValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CollectionConfiguration
  ): zio.aws.sagemaker.model.CollectionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
