package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  String256,
  ExperimentEntityName,
  ContextArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ContextSummary(
    contextArn: Optional[ContextArn] = Optional.Absent,
    contextName: Optional[ExperimentEntityName] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.ContextSource] = Optional.Absent,
    contextType: Optional[String256] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ContextSummary = {
    import ContextSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ContextSummary
      .builder()
      .optionallyWith(
        contextArn.map(value => ContextArn.unwrap(value): java.lang.String)
      )(_.contextArn)
      .optionallyWith(
        contextName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.contextName)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        contextType.map(value => String256.unwrap(value): java.lang.String)
      )(_.contextType)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ContextSummary.ReadOnly =
    zio.aws.sagemaker.model.ContextSummary.wrap(buildAwsValue())
}
object ContextSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ContextSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ContextSummary =
      zio.aws.sagemaker.model.ContextSummary(
        contextArn.map(value => value),
        contextName.map(value => value),
        source.map(value => value.asEditable),
        contextType.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def contextArn: Optional[ContextArn]
    def contextName: Optional[ExperimentEntityName]
    def source: Optional[zio.aws.sagemaker.model.ContextSource.ReadOnly]
    def contextType: Optional[String256]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getContextArn: ZIO[Any, AwsError, ContextArn] =
      AwsError.unwrapOptionField("contextArn", contextArn)
    def getContextName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("contextName", contextName)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ContextSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getContextType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("contextType", contextType)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ContextSummary
  ) extends zio.aws.sagemaker.model.ContextSummary.ReadOnly {
    override val contextArn: Optional[ContextArn] = zio.aws.core.internal
      .optionalFromNullable(impl.contextArn())
      .map(value => zio.aws.sagemaker.model.primitives.ContextArn(value))
    override val contextName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contextName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val source
        : Optional[zio.aws.sagemaker.model.ContextSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.ContextSource.wrap(value))
    override val contextType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.contextType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ContextSummary
  ): zio.aws.sagemaker.model.ContextSummary.ReadOnly = new Wrapper(impl)
}
