package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  CertifyForMarketplace,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class CreateAlgorithmRequest(
    algorithmName: EntityName,
    algorithmDescription: Optional[EntityDescription] = Optional.Absent,
    trainingSpecification: zio.aws.sagemaker.model.TrainingSpecification,
    inferenceSpecification: Optional[
      zio.aws.sagemaker.model.InferenceSpecification
    ] = Optional.Absent,
    validationSpecification: Optional[
      zio.aws.sagemaker.model.AlgorithmValidationSpecification
    ] = Optional.Absent,
    certifyForMarketplace: Optional[CertifyForMarketplace] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest = {
    import CreateAlgorithmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest
      .builder()
      .algorithmName(EntityName.unwrap(algorithmName): java.lang.String)
      .optionallyWith(
        algorithmDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.algorithmDescription)
      .trainingSpecification(trainingSpecification.buildAwsValue())
      .optionallyWith(
        inferenceSpecification.map(value => value.buildAwsValue())
      )(_.inferenceSpecification)
      .optionallyWith(
        validationSpecification.map(value => value.buildAwsValue())
      )(_.validationSpecification)
      .optionallyWith(
        certifyForMarketplace.map(value =>
          CertifyForMarketplace.unwrap(value): java.lang.Boolean
        )
      )(_.certifyForMarketplace)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateAlgorithmRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateAlgorithmRequest.wrap(buildAwsValue())
}
object CreateAlgorithmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAlgorithmRequest =
      zio.aws.sagemaker.model.CreateAlgorithmRequest(
        algorithmName,
        algorithmDescription.map(value => value),
        trainingSpecification.asEditable,
        inferenceSpecification.map(value => value.asEditable),
        validationSpecification.map(value => value.asEditable),
        certifyForMarketplace.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def algorithmName: EntityName
    def algorithmDescription: Optional[EntityDescription]
    def trainingSpecification
        : zio.aws.sagemaker.model.TrainingSpecification.ReadOnly
    def inferenceSpecification
        : Optional[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly]
    def validationSpecification: Optional[
      zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly
    ]
    def certifyForMarketplace: Optional[CertifyForMarketplace]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getAlgorithmName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(algorithmName)
    def getAlgorithmDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("algorithmDescription", algorithmDescription)
    def getTrainingSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TrainingSpecification.ReadOnly
    ] = ZIO.succeed(trainingSpecification)
    def getInferenceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceSpecification",
      inferenceSpecification
    )
    def getValidationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "validationSpecification",
      validationSpecification
    )
    def getCertifyForMarketplace: ZIO[Any, AwsError, CertifyForMarketplace] =
      AwsError.unwrapOptionField("certifyForMarketplace", certifyForMarketplace)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest
  ) extends zio.aws.sagemaker.model.CreateAlgorithmRequest.ReadOnly {
    override val algorithmName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.algorithmName())
    override val algorithmDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithmDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val trainingSpecification
        : zio.aws.sagemaker.model.TrainingSpecification.ReadOnly =
      zio.aws.sagemaker.model.TrainingSpecification
        .wrap(impl.trainingSpecification())
    override val inferenceSpecification
        : Optional[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSpecification())
        .map(value =>
          zio.aws.sagemaker.model.InferenceSpecification.wrap(value)
        )
    override val validationSpecification: Optional[
      zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationSpecification())
      .map(value =>
        zio.aws.sagemaker.model.AlgorithmValidationSpecification.wrap(value)
      )
    override val certifyForMarketplace: Optional[CertifyForMarketplace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certifyForMarketplace())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CertifyForMarketplace(value)
        )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest
  ): zio.aws.sagemaker.model.CreateAlgorithmRequest.ReadOnly = new Wrapper(impl)
}
