package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.AlgorithmArn
import scala.jdk.CollectionConverters.*
final case class CreateAlgorithmResponse(algorithmArn: AlgorithmArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse = {
    import CreateAlgorithmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse
      .builder()
      .algorithmArn(AlgorithmArn.unwrap(algorithmArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateAlgorithmResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateAlgorithmResponse.wrap(buildAwsValue())
}
object CreateAlgorithmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAlgorithmResponse =
      zio.aws.sagemaker.model.CreateAlgorithmResponse(algorithmArn)
    def algorithmArn: AlgorithmArn
    def getAlgorithmArn: ZIO[Any, Nothing, AlgorithmArn] =
      ZIO.succeed(algorithmArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse
  ) extends zio.aws.sagemaker.model.CreateAlgorithmResponse.ReadOnly {
    override val algorithmArn: AlgorithmArn =
      zio.aws.sagemaker.model.primitives.AlgorithmArn(impl.algorithmArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse
  ): zio.aws.sagemaker.model.CreateAlgorithmResponse.ReadOnly = new Wrapper(
    impl
  )
}
