package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.FlowDefinitionArn
import scala.jdk.CollectionConverters.*
final case class CreateFlowDefinitionResponse(
    flowDefinitionArn: FlowDefinitionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse = {
    import CreateFlowDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse
      .builder()
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateFlowDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateFlowDefinitionResponse.wrap(buildAwsValue())
}
object CreateFlowDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateFlowDefinitionResponse =
      zio.aws.sagemaker.model.CreateFlowDefinitionResponse(flowDefinitionArn)
    def flowDefinitionArn: FlowDefinitionArn
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse
  ) extends zio.aws.sagemaker.model.CreateFlowDefinitionResponse.ReadOnly {
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse
  ): zio.aws.sagemaker.model.CreateFlowDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
