package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionArn
import scala.jdk.CollectionConverters.*
final case class CreateModelQualityJobDefinitionResponse(
    jobDefinitionArn: MonitoringJobDefinitionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse = {
    import CreateModelQualityJobDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse
      .builder()
      .jobDefinitionArn(
        MonitoringJobDefinitionArn.unwrap(jobDefinitionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse
      .wrap(buildAwsValue())
}
object CreateModelQualityJobDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse =
      zio.aws.sagemaker.model
        .CreateModelQualityJobDefinitionResponse(jobDefinitionArn)
    def jobDefinitionArn: MonitoringJobDefinitionArn
    def getJobDefinitionArn: ZIO[Any, Nothing, MonitoringJobDefinitionArn] =
      ZIO.succeed(jobDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse
  ) extends zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.ReadOnly {
    override val jobDefinitionArn: MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionArn(impl.jobDefinitionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse
  ): zio.aws.sagemaker.model.CreateModelQualityJobDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
