package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringScheduleArn
import scala.jdk.CollectionConverters.*
final case class CreateMonitoringScheduleResponse(
    monitoringScheduleArn: MonitoringScheduleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse = {
    import CreateMonitoringScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse
      .builder()
      .monitoringScheduleArn(
        MonitoringScheduleArn.unwrap(monitoringScheduleArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateMonitoringScheduleResponse
      .wrap(buildAwsValue())
}
object CreateMonitoringScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateMonitoringScheduleResponse =
      zio.aws.sagemaker.model
        .CreateMonitoringScheduleResponse(monitoringScheduleArn)
    def monitoringScheduleArn: MonitoringScheduleArn
    def getMonitoringScheduleArn: ZIO[Any, Nothing, MonitoringScheduleArn] =
      ZIO.succeed(monitoringScheduleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse
  ) extends zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.ReadOnly {
    override val monitoringScheduleArn: MonitoringScheduleArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleArn(impl.monitoringScheduleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse
  ): zio.aws.sagemaker.model.CreateMonitoringScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
