package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PipelineArn
import scala.jdk.CollectionConverters.*
final case class CreatePipelineResponse(
    pipelineArn: Optional[PipelineArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse = {
    import CreatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreatePipelineResponse.ReadOnly =
    zio.aws.sagemaker.model.CreatePipelineResponse.wrap(buildAwsValue())
}
object CreatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreatePipelineResponse =
      zio.aws.sagemaker.model
        .CreatePipelineResponse(pipelineArn.map(value => value))
    def pipelineArn: Optional[PipelineArn]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse
  ) extends zio.aws.sagemaker.model.CreatePipelineResponse.ReadOnly {
    override val pipelineArn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse
  ): zio.aws.sagemaker.model.CreatePipelineResponse.ReadOnly = new Wrapper(impl)
}
