package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PresignedDomainUrl
import scala.jdk.CollectionConverters.*
final case class CreatePresignedDomainUrlResponse(
    authorizedUrl: Optional[PresignedDomainUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse = {
    import CreatePresignedDomainUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse
      .builder()
      .optionallyWith(
        authorizedUrl.map(value =>
          PresignedDomainUrl.unwrap(value): java.lang.String
        )
      )(_.authorizedUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.ReadOnly =
    zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse
      .wrap(buildAwsValue())
}
object CreatePresignedDomainUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse =
      zio.aws.sagemaker.model
        .CreatePresignedDomainUrlResponse(authorizedUrl.map(value => value))
    def authorizedUrl: Optional[PresignedDomainUrl]
    def getAuthorizedUrl: ZIO[Any, AwsError, PresignedDomainUrl] =
      AwsError.unwrapOptionField("authorizedUrl", authorizedUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse
  ) extends zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.ReadOnly {
    override val authorizedUrl: Optional[PresignedDomainUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizedUrl())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PresignedDomainUrl(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse
  ): zio.aws.sagemaker.model.CreatePresignedDomainUrlResponse.ReadOnly =
    new Wrapper(impl)
}
