package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{EntityDescription, ProjectEntityName}
import scala.jdk.CollectionConverters.*
final case class CreateProjectRequest(
    projectName: ProjectEntityName,
    projectDescription: Optional[EntityDescription] = Optional.Absent,
    serviceCatalogProvisioningDetails: zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest
      .builder()
      .projectName(ProjectEntityName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        projectDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .serviceCatalogProvisioningDetails(
        serviceCatalogProvisioningDetails.buildAwsValue()
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateProjectRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateProjectRequest =
      zio.aws.sagemaker.model.CreateProjectRequest(
        projectName,
        projectDescription.map(value => value),
        serviceCatalogProvisioningDetails.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def projectName: ProjectEntityName
    def projectDescription: Optional[EntityDescription]
    def serviceCatalogProvisioningDetails
        : zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getProjectName: ZIO[Any, Nothing, ProjectEntityName] =
      ZIO.succeed(projectName)
    def getProjectDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getServiceCatalogProvisioningDetails: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    ] = ZIO.succeed(serviceCatalogProvisioningDetails)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest
  ) extends zio.aws.sagemaker.model.CreateProjectRequest.ReadOnly {
    override val projectName: ProjectEntityName =
      zio.aws.sagemaker.model.primitives.ProjectEntityName(impl.projectName())
    override val projectDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val serviceCatalogProvisioningDetails
        : zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly =
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails
        .wrap(impl.serviceCatalogProvisioningDetails())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest
  ): zio.aws.sagemaker.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
