package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TrialComponentKey64,
  TrialComponentKey256,
  Timestamp,
  ExperimentEntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateTrialComponentRequest(
    trialComponentName: ExperimentEntityName,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.TrialComponentStatus] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue
    ]] = Optional.Absent,
    inputArtifacts: Optional[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = Optional.Absent,
    outputArtifacts: Optional[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest = {
    import CreateTrialComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest
      .builder()
      .trialComponentName(
        ExperimentEntityName.unwrap(trialComponentName): java.lang.String
      )
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey256.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        inputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.inputArtifacts)
      .optionallyWith(
        outputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.outputArtifacts)
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateTrialComponentRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateTrialComponentRequest.wrap(buildAwsValue())
}
object CreateTrialComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateTrialComponentRequest =
      zio.aws.sagemaker.model.CreateTrialComponentRequest(
        trialComponentName,
        displayName.map(value => value),
        status.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        inputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        outputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        metadataProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trialComponentName: ExperimentEntityName
    def displayName: Optional[ExperimentEntityName]
    def status: Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]]
    def inputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def outputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getTrialComponentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialComponentName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getParameters: ZIO[Any, AwsError, Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getInputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getOutputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest
  ) extends zio.aws.sagemaker.model.CreateTrialComponentRequest.ReadOnly {
    override val trialComponentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.trialComponentName())
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val status
        : Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.TrialComponentStatus.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentParameterValue
              .wrap(value)
          })
          .toMap
      )
    override val inputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.inputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val outputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.outputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest
  ): zio.aws.sagemaker.model.CreateTrialComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
