package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.UserProfileArn
import scala.jdk.CollectionConverters.*
final case class CreateUserProfileResponse(
    userProfileArn: Optional[UserProfileArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse = {
    import CreateUserProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse
      .builder()
      .optionallyWith(
        userProfileArn.map(value =>
          UserProfileArn.unwrap(value): java.lang.String
        )
      )(_.userProfileArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateUserProfileResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateUserProfileResponse.wrap(buildAwsValue())
}
object CreateUserProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateUserProfileResponse =
      zio.aws.sagemaker.model
        .CreateUserProfileResponse(userProfileArn.map(value => value))
    def userProfileArn: Optional[UserProfileArn]
    def getUserProfileArn: ZIO[Any, AwsError, UserProfileArn] =
      AwsError.unwrapOptionField("userProfileArn", userProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse
  ) extends zio.aws.sagemaker.model.CreateUserProfileResponse.ReadOnly {
    override val userProfileArn: Optional[UserProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileArn())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse
  ): zio.aws.sagemaker.model.CreateUserProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
