package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ProcessingLocalPath
import scala.jdk.CollectionConverters.*
final case class DatasetDefinition(
    athenaDatasetDefinition: Optional[
      zio.aws.sagemaker.model.AthenaDatasetDefinition
    ] = Optional.Absent,
    redshiftDatasetDefinition: Optional[
      zio.aws.sagemaker.model.RedshiftDatasetDefinition
    ] = Optional.Absent,
    localPath: Optional[ProcessingLocalPath] = Optional.Absent,
    dataDistributionType: Optional[
      zio.aws.sagemaker.model.DataDistributionType
    ] = Optional.Absent,
    inputMode: Optional[zio.aws.sagemaker.model.InputMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DatasetDefinition = {
    import DatasetDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DatasetDefinition
      .builder()
      .optionallyWith(
        athenaDatasetDefinition.map(value => value.buildAwsValue())
      )(_.athenaDatasetDefinition)
      .optionallyWith(
        redshiftDatasetDefinition.map(value => value.buildAwsValue())
      )(_.redshiftDatasetDefinition)
      .optionallyWith(
        localPath.map(value =>
          ProcessingLocalPath.unwrap(value): java.lang.String
        )
      )(_.localPath)
      .optionallyWith(dataDistributionType.map(value => value.unwrap))(
        _.dataDistributionType
      )
      .optionallyWith(inputMode.map(value => value.unwrap))(_.inputMode)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DatasetDefinition.ReadOnly =
    zio.aws.sagemaker.model.DatasetDefinition.wrap(buildAwsValue())
}
object DatasetDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DatasetDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DatasetDefinition =
      zio.aws.sagemaker.model.DatasetDefinition(
        athenaDatasetDefinition.map(value => value.asEditable),
        redshiftDatasetDefinition.map(value => value.asEditable),
        localPath.map(value => value),
        dataDistributionType.map(value => value),
        inputMode.map(value => value)
      )
    def athenaDatasetDefinition
        : Optional[zio.aws.sagemaker.model.AthenaDatasetDefinition.ReadOnly]
    def redshiftDatasetDefinition
        : Optional[zio.aws.sagemaker.model.RedshiftDatasetDefinition.ReadOnly]
    def localPath: Optional[ProcessingLocalPath]
    def dataDistributionType
        : Optional[zio.aws.sagemaker.model.DataDistributionType]
    def inputMode: Optional[zio.aws.sagemaker.model.InputMode]
    def getAthenaDatasetDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AthenaDatasetDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "athenaDatasetDefinition",
      athenaDatasetDefinition
    )
    def getRedshiftDatasetDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RedshiftDatasetDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftDatasetDefinition",
      redshiftDatasetDefinition
    )
    def getLocalPath: ZIO[Any, AwsError, ProcessingLocalPath] =
      AwsError.unwrapOptionField("localPath", localPath)
    def getDataDistributionType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DataDistributionType] =
      AwsError.unwrapOptionField("dataDistributionType", dataDistributionType)
    def getInputMode: ZIO[Any, AwsError, zio.aws.sagemaker.model.InputMode] =
      AwsError.unwrapOptionField("inputMode", inputMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DatasetDefinition
  ) extends zio.aws.sagemaker.model.DatasetDefinition.ReadOnly {
    override val athenaDatasetDefinition
        : Optional[zio.aws.sagemaker.model.AthenaDatasetDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.athenaDatasetDefinition())
        .map(value =>
          zio.aws.sagemaker.model.AthenaDatasetDefinition.wrap(value)
        )
    override val redshiftDatasetDefinition
        : Optional[zio.aws.sagemaker.model.RedshiftDatasetDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshiftDatasetDefinition())
        .map(value =>
          zio.aws.sagemaker.model.RedshiftDatasetDefinition.wrap(value)
        )
    override val localPath: Optional[ProcessingLocalPath] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localPath())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ProcessingLocalPath(value)
        )
    override val dataDistributionType
        : Optional[zio.aws.sagemaker.model.DataDistributionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataDistributionType())
        .map(value => zio.aws.sagemaker.model.DataDistributionType.wrap(value))
    override val inputMode: Optional[zio.aws.sagemaker.model.InputMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputMode())
        .map(value => zio.aws.sagemaker.model.InputMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DatasetDefinition
  ): zio.aws.sagemaker.model.DatasetDefinition.ReadOnly = new Wrapper(impl)
}
