package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ContextArn
import scala.jdk.CollectionConverters.*
final case class DeleteContextResponse(
    contextArn: Optional[ContextArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse = {
    import DeleteContextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse
      .builder()
      .optionallyWith(
        contextArn.map(value => ContextArn.unwrap(value): java.lang.String)
      )(_.contextArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteContextResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteContextResponse.wrap(buildAwsValue())
}
object DeleteContextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteContextResponse =
      zio.aws.sagemaker.model
        .DeleteContextResponse(contextArn.map(value => value))
    def contextArn: Optional[ContextArn]
    def getContextArn: ZIO[Any, AwsError, ContextArn] =
      AwsError.unwrapOptionField("contextArn", contextArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse
  ) extends zio.aws.sagemaker.model.DeleteContextResponse.ReadOnly {
    override val contextArn: Optional[ContextArn] = zio.aws.core.internal
      .optionalFromNullable(impl.contextArn())
      .map(value => zio.aws.sagemaker.model.primitives.ContextArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse
  ): zio.aws.sagemaker.model.DeleteContextResponse.ReadOnly = new Wrapper(impl)
}
