package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointName
import scala.jdk.CollectionConverters.*
final case class DeleteEndpointRequest(endpointName: EndpointName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest = {
    import DeleteEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteEndpointRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteEndpointRequest.wrap(buildAwsValue())
}
object DeleteEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteEndpointRequest =
      zio.aws.sagemaker.model.DeleteEndpointRequest(endpointName)
    def endpointName: EndpointName
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest
  ) extends zio.aws.sagemaker.model.DeleteEndpointRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest
  ): zio.aws.sagemaker.model.DeleteEndpointRequest.ReadOnly = new Wrapper(impl)
}
