package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.FeatureGroupName
import scala.jdk.CollectionConverters.*
final case class DeleteFeatureGroupRequest(featureGroupName: FeatureGroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest = {
    import DeleteFeatureGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteFeatureGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteFeatureGroupRequest.wrap(buildAwsValue())
}
object DeleteFeatureGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteFeatureGroupRequest =
      zio.aws.sagemaker.model.DeleteFeatureGroupRequest(featureGroupName)
    def featureGroupName: FeatureGroupName
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest
  ) extends zio.aws.sagemaker.model.DeleteFeatureGroupRequest.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupName(impl.featureGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest
  ): zio.aws.sagemaker.model.DeleteFeatureGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
