package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class DeleteModelPackageGroupPolicyRequest(
    modelPackageGroupName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest = {
    import DeleteModelPackageGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest
      .builder()
      .modelPackageGroupName(
        EntityName.unwrap(modelPackageGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteModelPackageGroupPolicyRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteModelPackageGroupPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteModelPackageGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DeleteModelPackageGroupPolicyRequest =
      zio.aws.sagemaker.model
        .DeleteModelPackageGroupPolicyRequest(modelPackageGroupName)
    def modelPackageGroupName: EntityName
    def getModelPackageGroupName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest
  ) extends zio.aws.sagemaker.model.DeleteModelPackageGroupPolicyRequest.ReadOnly {
    override val modelPackageGroupName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelPackageGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest
  ): zio.aws.sagemaker.model.DeleteModelPackageGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
