package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringScheduleName
import scala.jdk.CollectionConverters.*
final case class DeleteMonitoringScheduleRequest(
    monitoringScheduleName: MonitoringScheduleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest = {
    import DeleteMonitoringScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteMonitoringScheduleRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteMonitoringScheduleRequest
      .wrap(buildAwsValue())
}
object DeleteMonitoringScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteMonitoringScheduleRequest =
      zio.aws.sagemaker.model
        .DeleteMonitoringScheduleRequest(monitoringScheduleName)
    def monitoringScheduleName: MonitoringScheduleName
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest
  ) extends zio.aws.sagemaker.model.DeleteMonitoringScheduleRequest.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest
  ): zio.aws.sagemaker.model.DeleteMonitoringScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
